/*:
 * @plugindesc Xキーおよび右クリック後にZキーを一定時間無効にする
 * @author
 *
 * @param DisableDuration
 * @text Zキー無効時間（ms）
 * @type number
 * @default 300
 */

(() => {
    const parameters = PluginManager.parameters(document.currentScript.src.match(/([^\/]+)\.js$/)[1]);
    const disableDuration = Number(parameters['DisableDuration'] || 300);

    let zKeyDisabledUntil = 0;

    // Zキーの抑制（isPressed / isTriggered 両方）
    const _Input_isPressed = Input.isPressed;
    Input.isPressed = function(keyName) {
        if (keyName === 'ok' && Date.now() < zKeyDisabledUntil) return false;
        return _Input_isPressed.call(this, keyName);
    };

    const _Input_isTriggered = Input.isTriggered;
    Input.isTriggered = function(keyName) {
        if (keyName === 'ok' && Date.now() < zKeyDisabledUntil) return false;
        return _Input_isTriggered.call(this, keyName);
    };

    // Xキー（cancel）・右クリックに反応してZキー無効タイマー開始
    const _Input_update = Input.update;
    Input.update = function() {
        _Input_update.call(this);
        if (Input.isTriggered('cancel') || TouchInput.isCancelled()) {
            zKeyDisabledUntil = Date.now() + disableDuration;
        }
    };

    // TouchInput.isCancelled にフック（右クリックを捕捉）
    const _TouchInput_isCancelled = TouchInput.isCancelled;
    TouchInput.isCancelled = function() {
        const result = _TouchInput_isCancelled.call(this);
        if (result) {
            zKeyDisabledUntil = Date.now() + disableDuration;
        }
        return result;
    };
})();